# sample match failure (VEP orphan):

use NGS::Test::Common; # imports all required modules (NGS, Plack::Test, etc)

my $app = NGS->to_app;
my $test = Plack::Test->create($app);

# test data ====================================================================
my @test_data = (
    [
        'RUNX exon 4.1',
        '89:A/T',
        'Accepted',
        43.50, 177,
        43.50, 177,
    ],
);
# ==============================================================================

my @content = create_content(\@test_data); # can return either array, or arrayref
my $response = $test->request( POST '/vep', @content ); # print_response($response);
is( $response->code, 200, '[POST /vep] success' );

# RUNX exon 4.1 [89] - VEP orphan
like( $response->content, qr{RUNX exon 4.1 \[89:A/T\]} );
like( $response->content, qr{Processed 1 vep input rows} );
like( $response->content, qr{Sample results for data src "data.txt" \[0\]} );
like( $response->content, qr{Sample match failures \[1\]} );
like( $response->content, qr{VEP results \[0\]});
like( $response->content, qr{Non-CDS VEP results \[1\]});
unlike( $response->content, qr{_variant} ); # none

done_testing;