# sample match using separate data src file; repeat with 'coding_only' off:

use NGS::Test::Common; # imports all required modules (NGS, Plack::Test, etc)

my $app = NGS->to_app;
my $test = Plack::Test->create($app);
{
	my $response = $test->request( GET '/vep' ); # p $response;
	is( $response->code, 200, '[GET /vep] success' );
}

# test data ====================================================================
my $params = form_params('core'); # common params - supply db
$params->{data_src} = [ $Bin .'/data/003_data.txt' ]; # p $params;

my $response = $test->request( POST '/vep', (
		'Content_Type' => 'form-data',
		'Content' => $params,
	)
); # print_response($response);
is( $response->code, 200, '[POST /vep] success' );
   
# ASXL exon 12.7 [120]
like( $response->content, qr{ASXL exon 12.7 \[120:C/T\]} );
like( $response->content, qr{missense_variant} );
like( $response->content, qr{Processed 1 vep input rows} );
like( $response->content, qr{Sample results for data src "003_data.txt" \[1\]} );
like( $response->content, qr{Sample match failures \[0\]} );
like( $response->content, qr{VEP results \[2\]} );
like( $response->content, qr{Non-CDS VEP results \[0\]} );
# downstream_gene_variant should only be present when coding_only NOT selected:
unlike( $response->content, qr{downstream_gene_variant} );

# repeat with 'variants in coding regions only' off:
{
    local $params->{coding_only} = 0;
    $response = $test->request( POST '/vep', (
		'Content_Type' => 'form-data',
		'Content' => $params,
	));  print_response($response);
  
   like( $response->content, qr{downstream_gene_variant} );
   like( $response->content, qr{VEP results \[4\]} );
} # warn Dumper $params;

done_testing;