use Test::More import => ['!pass'];

use strict;
use warnings;

# the order is important
use NGS with => {logger => 'console', log => 'error'};
use Dancer2::Test apps => ['NGS'];
$Dancer2::Test::NO_WARN = 1;

route_exists [GET => '/'], 'a route handler is defined for /';
response_status_is ['GET' => '/'], 200, 'response status is 200 for /';

route_exists [GET => '/vep'], 'a route handler is defined for /vep';
response_status_is ['GET' => '/vep'], 200, 'response status is 200 for /vep';

# fails in D2 v0.142 - default route handler in Dancer2::Handler::File
# route_doesnt_exist [GET => '/foo'], 'a route handler is not defined for /foo';
response_status_is ['GET' => '/foo'], 404, 'response status is 404 for /foo';

done_testing;