package NGS::VEP::BioSphere;

# get some details about the offline vep cache & Bio::EnsEMBL::ApiVersion

use FindBin qw($Bin); # warn $Bin;

use IO::All;
use Data::Dumper;
use Bio::EnsEMBL::ApiVersion qw(software_version);

use Moo;
has api_version => ( is => 'lazy' ); # but gets called for each new request ??why
sub _build_api_version { return Bio::EnsEMBL::ApiVersion::software_version }

#-------------------------------------------------------------------------------
sub get_cache_types {
    my $self = shift;
    
    my $version = $self->api_version(); # Bio::EnsEMBL::ApiVersion
    my $cache_dir = _get_cache_dir(); # vep.ini 'dir' entry 
    
    my @types; # core, refseq, merged
    
    my $io = io($cache_dir.'/'); # has to have trailing '/' or $io is undef ??
    # restrict to 3 levels deep - otherwise get thousands !!
    for ( $io->all(3) ) { # warn "$_ is a " . $_->type;
        # only want directories containing "homo_sapiens/$version" (eg 75, 76_GRCh37):
        next unless $_->type eq 'dir' && $_->file =~ m!homo_sapiens/$version!;
        # my @dirs = $_->splitdir; # warn Dumper \@dirs; # need to know file-structure
        # push @types, $dirs[4]; # index #4 as 1st is empty /home/raj/.vep/foo 
        my ($str) = $_->file =~ m!$cache_dir/(\w+)/!; # warn $str;
        push @types, $str;
    } # warn Dumper @types;
    return \@types;
}

#-------------------------------------------------------------------------------
sub _get_cache_dir {
    my $src = "$Bin/../script/vep.ini";
    my $contents = io($src)->slurp; # warn $contents;
    my ($cache_dir) = $contents =~ /\bdir\b\s+(.*)/; # warn $cache_dir;
    return $cache_dir;
}

1;