#!/usr/bin/env perl

# starts the plackup -s Startman -a NGS/bin/app.pl process
# init.d script needs PERL5LIB env var set so plackup can find Plack::Runner

use warnings;
use strict;

use lib '/home/raj/perl5/lib/perl5';
use Daemon::Control;
# use Plack::Runner; # only needed if using direct in program sub
use Data::Dumper;

use FindBin qw($Bin);  # load AFTER local::lib Carp or FindBin loads system Carp

my $GROUP  = $ENV{APACHE_GROUP} || die 'no APACHE_GROUP env var set'; # warn $GROUP;
my $USER   = $ENV{APACHE_USER}  || die 'no APACHE_USER env var set';  # warn $USER;

my $run_dir  = '/var/run/ngs'; # location of pid file & stderr
my $app_home = '/home/raj/apps/NGS';
my $program  = '/home/raj/perl5/bin/plackup';
my $pid_file = $run_dir . '/ngs.pid';
my $stdout   = $app_home . '/logs/deployment.log';
my $stderr 	 = $stdout; # combined
my $workers  = 2;
my $port     = 5001;
my $name     = 'NGS';
my $app      = 'app.pl';

my @program_args = (
	-s => 'Starman',
	-a => "$app_home/bin/$app",
	-p => $port,
	-E => 'deployment', # tells dancer app which env & logs to use
	'--workers' => $workers,
);

my %args = (
    name         => $name,
#    lsb_start   => '$syslog $remote_fs',
#    lsb_stop    => '$syslog',
    lsb_sdesc    => $name,
    lsb_desc     => $name,
    path         => $0, # this script
    program      => $program,
#    program      => \&program, # uses Plack::Runner direct
    program_args => \@program_args,

    pid_file     => $pid_file,
    stderr_file  => $stderr,
    stdout_file  => $stdout,

	user         => $USER,
    group        => $GROUP,
    fork         => 2,
); # warn Dumper \%args;

Daemon::Control->new(\%args)->run;

sub program {
	my $runner = Plack::Runner->new;
	$runner->parse_options(@program_args);
	$runner->run;
}

__END__
#!/bin/sh
### BEGIN INIT INFO
# Provides:          NGS
# Required-Start:
# Required-Stop:
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: NGS daemon
# Description:       Controls the ngs_daemon script
### END INIT INFO

export APACHE_USER=www-data
export APACHE_GROUP=www-data
# so plackup can find Plack::Runner:
export PERL5LIB=/home/raj/perl5/lib/perl5

SCRIPT_DIR=/home/raj/apps/NGS/bin
SCRIPT=ngs.pl

if [ -x $SCRIPT_DIR/$SCRIPT ];
then
    cd $SCRIPT_DIR
    /usr/bin/perl $SCRIPT $@
else
    echo "Required program $SCRIPT_DIR/$SCRIPT not found!"
    exit 1;
fi
