use Test::More import => ['!pass'];

use NGS with => { logger => 'console', log => 'error' }; # spare console from overload
use FindBin qw($Bin); # warn $Bin;
use Dancer2::Test apps => ['NGS'];
use Data::Dumper;
use Modern::Perl;

require 't/test-lib.pl';

# decimal in variant

# test data ====================================================================
my @test_data = (
    # 'normal' variant; needed to avoid 'ERROR: Could not detect input file format':
    [
        'DNMT3A exon 15', 
        '41:G/T',
        'Accepted',
        11.6, 163,
        11.6, 163,
    ],
    # non-standard variant format:
    [
        'FLT3-ITD 1',
        'i(278.5,TGAGATCATATTCATATTTGAGATCATATTCATATT)', 
        'Accepted',
        11.6, 163,
        11.6, 163,
    ],
    # variant contains decimal (invalid base):
    [
        'NPM1 exon 12.1',	
        '133.5:--/CC', 
        'Accepted',
        11.6, 163,
        11.6, 163,
    ],
);
# ==============================================================================

my $args = construct_request(\@test_data);

my $response = dancer_response( POST => '/vep', $args );  print_output($response);
response_status_is $response => 200; # exit;

response_content_like $response => qr(cannot split FLT3-ITD 1 variant);
response_content_like $response => qr(FLT3-ITD 1 omitted from VEP input);
response_content_like $response => qr(DNMT3A exon 15 \[41:G/T\]);
response_content_like $response => qr(NPM1 exon 12.1 \[133.5:--/CC\]);
response_content_like $response => qr(Processed 3 accepted rows);
response_content_like $response => qr(Sample match failures \[2\]);
response_content_like $response => qr(Non-CDS VEP results \[2\]);

done_testing;