use Test::More import => ['!pass'];

use strict;
use warnings;

# the order is important
use NGS with => {logger => 'console', log => 'error'};
use Dancer2::Test apps => ['NGS'];

route_exists [GET => '/'], 'a route handler is defined for /';
response_status_is ['GET' => '/'], 200, 'response status is 200 for /';

route_exists [GET => '/vep'], 'a route handler is defined for /vep';
response_status_is ['GET' => '/vep'], 200, 'response status is 200 for /vep';

SKIP: { # doesn't work for 404's at v0.04
    skip('require Dancer2 > 0.04',2) unless $Dancer2::VERSION > 0.04;
    route_doesnt_exist [GET => '/foo'], 'a route handler is not defined for /foo';
    response_status_is ['GET' => '/foo'], 404, 'response status is 404 for /foo';
}

done_testing;