package NGS::MooX::Types;

use MooX::Types::MooseLike;

use base qw(Exporter);
our @EXPORT_OK = ();

# define some types
my @defs = (
	{
        name 	=> 'HashReference',
        test	=> sub { ref $_[0] eq 'HASH' },
        message => sub { "$_[0] is not a hashref" }
	},
	{
        name 	=> 'ArrayReference',
        test	=> sub { ref $_[0] eq 'ARRAY' },
        message => sub { "$_[0] is not an arrayref" }
	},
    { # from the docs: isa => VarChar[25]:
        name => 'VarChar',
        test => sub {
            my ($value, $param) = @_;
            length($value) <= $param;
        },
        message => sub { "$_[0] is too large! It should be <= $_[1]" }
    },
    {
      name    => 'String', # test taken from MooX/Types/MooseLike/Base.pm source-code:
      test    => sub { defined $_[0] and (ref(\$_[0]) eq 'SCALAR') },
      message => sub { "$_[0] is not a string" },
    },
);
MooX::Types::MooseLike::register_types(\@defs, __PACKAGE__);

1;
