use Test::More import => ['!pass'];

use NGS with => { logger => 'console', log => 'error' }; # spare console from overload
use FindBin qw($Bin); # warn $Bin;
use Dancer2::Test apps => ['NGS'];
use Data::Dumper;
use Modern::Perl;

require 't/test-lib.pl';

# multiple point mutations at same location:

# test data ====================================================================
my @test_data = (
    [
        'N-Ras exon 2.1',
        '141:C/G',
        'Accepted',
        6.5, 446,
        6.5, 446,
    ],
    [
        'N-Ras exon 2.1',
        '141:C/T',
        'Accepted',
        50.83, 120,
        50.83, 120,
    ],
);
# ==============================================================================

my $args = construct_request(\@test_data); # warn Dumper $args; exit;

my $response = dancer_response( POST => '/vep', $args ); # print_output($response);
response_status_is $response => 200; # exit;

response_content_like $response => qr(N-Ras exon 2.1 \[141:C/G\]); 
response_content_like $response => qr(N-Ras exon 2.1 \[141:C/T\]); 
response_content_like $response => qr(Processed 2 accepted rows);
response_content_like $response => qr(Sample results for data src "data.txt" \[2\]);
response_content_like $response => qr(Sample match failures \[0\]);
response_content_like $response => qr(VEP results \[2\]);
response_content_like $response => qr(Non-CDS VEP results \[0\]);

done_testing;