use Test::More import => ['!pass'];

use NGS with => { logger => 'console', log => 'error' }; # spare console from overload
use FindBin qw($Bin); # warn $Bin;
use Dancer2::Test apps => ['NGS'];
use Data::Dumper;
use Modern::Perl;

require 't/test-lib.pl';

# tests _want_vep_result() logic:

# test data ====================================================================
my @test_data = ( # synonymous_variant + variation =~ COSM*
    [
        'p53 exon 6.2 NEW',
        '137:T/C',
        'Accepted',
        100, 8,
        4.94, 81,
    ],
);
# ==============================================================================

my $args = construct_request(\@test_data);

my $response = dancer_response( POST => '/vep', $args ); # print_output($response);
response_status_is $response => 200; # exit;

# result = 'match' on COSM:
response_content_like $response => qr(p53 exon 6.2 NEW \[137:T/C\]); 
response_content_like $response => qr(Processed 1 vep input rows);
response_content_like $response => qr(Sample results for data src "data.txt" \[1\]);
response_content_like $response => qr(Sample match failures \[0\]);
response_content_like $response => qr(VEP results \[8\]);
response_content_like $response => qr(Non-CDS VEP results \[0\]);
response_content_like $response => qr(synonymous_variant);

{ # substitute WT exon 7.2 [177:G/C] - stop_gained with variation = '-':
    $test_data[0][0] = 'WT exon 7.2';
    $test_data[0][1] = '177:G/C'; # warn Dumper \@test_data;
    $args = construct_request(\@test_data);
    
    # result = 'match' on var = '-' & consequence not synonymous_variant
    $response = dancer_response( POST => '/vep', $args ); # print_output($response);
    response_status_is $response => 200; # exit;
    response_content_like $response => qr(Sample results for data src "data.txt" \[1\]);
    response_content_like $response => qr(Sample match failures \[0\]);
    response_content_like $response => qr(VEP results \[7\]);
}
{ # substitute WT exon 7.2 [177:G/A] - synonymous_variant with variation = '-':
    $test_data[0][0] = 'WT exon 7.2';
    $test_data[0][1] = '177:G/A'; # warn Dumper \@test_data;
    $args = construct_request(\@test_data);
    
    $response = dancer_response( POST => '/vep', $args ); # print_output($response);
    response_status_is $response => 200; # exit;
    
    # result = 'no match' on consequence = synonymous_variant
    response_content_like $response => qr(WT exon 7.2 \[177:G/A\]);
    response_content_like $response => qr(Sample results for data src "data.txt" \[0\]);
    response_content_like $response => qr(Sample match failures \[1\]);
    response_content_like $response => qr(VEP results \[7\]);
}

{ # substitute ASXL exon 12.2 [157:G/A] - missense_variant with variation =~ 'rs*':
    $test_data[0][0] = 'ASXL exon 12.2';
    $test_data[0][1] = '157:G/A'; # warn Dumper \@test_data;
    $args = construct_request(\@test_data);
    
    $response = dancer_response( POST => '/vep', $args ); # print_output($response);
    response_status_is $response => 200; # exit;
    
    # result = 'no match' on variation not one of COSM*, TMP* or '-'
    response_content_like $response => qr(ASXL exon 12.2 \[157:G/A\]);
    response_content_like $response => qr(Sample results for data src "data.txt" \[0\]);
    response_content_like $response => qr(Sample match failures \[1\]);
    response_content_like $response => qr(VEP results \[2\]);
}

{ # substitute IDH 1.1 [146:G/A] - synonymous_variant with variation =~ 'rs*':
    $test_data[0][0] = 'IDH 1.1';
    $test_data[0][1] = '146:G/A'; # warn Dumper \@test_data;
    $args = construct_request(\@test_data);
    
    $response = dancer_response( POST => '/vep', $args ); # print_output($response);
    response_status_is $response => 200; # exit;
    
    # result = 'no match' on synonymous_variant and not COSM*
    response_content_like $response => qr(IDH 1.1 \[146:G/A\]);
    response_content_like $response => qr(Sample results for data src "data.txt" \[0\]);
    response_content_like $response => qr(Sample match failures \[1\]);
    response_content_like $response => qr(VEP results \[4\]);
}

done_testing;