# 2 exons, one accepted 1 rejected:

use NGS::Test::Common; # imports all required modules (NGS, Plack::Test, etc)

my $app = NGS->to_app;
my $test = Plack::Test->create($app);

# test data ====================================================================
my @test_data = (
    [
        'ASXL exon 12.7',
        '120:C/T',
        'Accepted',
        100, 8,
        100, 8,
    ],
    [
        'ASXL exon 12.2',
        '183:N/G',
        'Rejected',
        100, 78,
        100, 21,
    ],
);
# ==============================================================================

my $content = create_content(\@test_data); # can return either array, or arrayref
my $response = $test->request( POST '/vep', @$content ); # print_response($response);
is( $response->code, 200, '[POST /vep] success' );

# K-Ras exon 2.1 [137] - VEP orphan
check_response( 'ASXL exon 12.7 \[120:C/T\]' ); 
check_response( 'Processed 1 vep input rows' );
check_response( 'Sample results for data src "data.txt" \[1\]' );
check_response( 'Sample match failures \[0\]' );
check_response( 'VEP results \[2\]' );
check_response( 'Non-CDS VEP results \[0\]' );
check_response( 'missense_variant' );
check_response( '1/10' );

sub check_response { like( $response->content, qr(@_) ) }

done_testing;