# 2 exons producing same chr location and base substitution (2_25466888_G/T)
# 1 non-existant entry in ref table

use NGS::Test::Common; # imports all required modules (NGS, Plack::Test, etc)

my $app = NGS->to_app;
my $test = Plack::Test->create($app);

# test data ====================================================================
my @test_data = (
    [
        'DNMT3A exon 15',	
        '41:G/T', # => 2_25466888_G/T
        'Accepted',
        11.6, 163,
        11.6, 163,
    ],
    [
        'DNMT3A exon 16',	
        '227:G/T', # => 2_25466888_G/T - overwrites DNMT3A exon 15 [41:G/T] entry
        'Accepted',
        11.6, 163,
        11.6, 163,
    ],
    [
        'DNMT3A exon 99',	# fictitious
        '29:G/T',
        'Accepted',
        11.6, 163,
        11.6, 163,
    ],
);
# ==============================================================================
my $content = create_content(\@test_data); # can return either array, or arrayref
my $response = $test->request( POST '/vep', @$content ); # print_response($response);
is( $response->code, 200, '[POST /vep] success' );

check_response( 'no ref table entry for DNMT3A exon 99' );
check_response( 'DNMT3A exon 99 omitted from VEP input' );
check_response( 'DNMT3A exon 15 omitted from VEP input' );
check_response( 'DNMT3A exon 16 \[227:G/T\]' );
check_response( 'non-CDS' ); # not an exon region
check_response( '2 vep input rows' );
check_response( '3 accepted/filtered rows' );
check_response( '3 total source file rows' );

sub check_response { like( $response->content, qr(@_) ) }

done_testing;