use Test::More import => ['!pass'];

# tests myseq.zip file upload - replaces deprecated Dancer2::Test with
# LWP::Protocol::PSGI

use Modern::Perl;
use Data::Printer;

use Test::WWW::Mechanize;
use LWP::Protocol::PSGI;
use FindBin qw($Bin); # warn $Bin;

use NGS with => {
    logger => 'file',
    log    => 'error',
    engines => {
        logger => {
            file => {
                file_name => 'test.log',
                log_dir   => 'logs',
            }
        }
    }
};

require 't/test-lib.pl';

my $psgi_app = NGS::runner()->psgi_app;
LWP::Protocol::PSGI->register($psgi_app);

my $mech = Test::WWW::Mechanize->new();
# test app response: 
$mech->get_ok( 'http://localhost/', 'OK: route handler is defined for /' );
is $mech->status => 200, "response status is 200 for '/'"; # print_output($mech);
 
$mech->get_ok( 'http://localhost/vep', 'OK: route handler is defined for /vep' );
is $mech->status => 200, "response status is 200 for '/vep'"; # print_output($mech);
$mech->title_is( 'Upload VEP DataFile', 'title is okay' );

my $params = form_params(); # common params
my @file = (
    $Bin .'/data/myseq.zip', # file on disk
    'myseq.zip',             # filename
);
$params->{data_src} = \@file;

say '###################################';
say "this test may take some time .....";
say '###################################';
$mech->post( 'http://localhost/vep',
    'Content_Type' => 'form-data',
    'Content' => $params,
);  print_output($mech);

$mech->text_contains($_) for (
    'Sample results for data src "myseq.zip" [5]',
    'Processed 5 vep input rows',
    '5 accepted/filtered rows',
    '8 total source file rows',
    'sample match failures [0]',
    'VEP results [23]',
    'non-CDS [0]',
);

done_testing;