use Test::More import => ['!pass'];

use NGS with => { logger => 'console', log => 'error' }; # spare console from overload
use FindBin qw($Bin); # warn $Bin;
use Dancer2::Test apps => ['NGS'];
use Data::Dumper;
use Modern::Perl;

require 't/test-lib.pl';

# test data ====================================================================
my @test_data = (
    [
        'RUNX exon 4.1',
        '89:A/T',
        'Accepted',
        43.50, 177,
        43.50, 177,
    ],
);
# ==============================================================================

my $args = construct_request(\@test_data);

my $response = dancer_response( POST => '/vep', $args ); # warn Dumper $response;
response_status_is $response => 200;

# RUNX exon 4.1 [89] - VEP orphan
response_content_like $response => qr(RUNX exon 4.1 \[89\]);
response_content_like $response => qr(Processed 1 accepted rows);
response_content_like $response => qr(Sample results \[0\]);
response_content_like $response => qr(Sample match failures \[1\]);
response_content_like $response => qr(VEP results \[0\]);
response_content_like $response => qr(VEP orphans \[1\]);
response_content_unlike $response => qr(variant); # none

done_testing;