use Test::More import => ['!pass'];

use NGS with => { logger => 'console', log => 'error' }; # spare console from overload
use FindBin qw($Bin); # warn $Bin;
use Dancer2::Test apps => ['NGS'];
use Data::Dumper;
use Modern::Perl;

require 't/test-lib.pl';

# core vs refseq vs merged transcription dbs (merged only v76+):

# test data ====================================================================
my @test_data = (
    [
        'N-Ras exon 3.1',
        '233:T/A',
        'Accepted',
        51.1, 66,
        0, 66,
        51.1, 66,
    ],
);

# core & refseq Gene & Feature cols:
my @refseq = qw(CCDS877.1 NM_002524.4 4893);
my @core   = qw(ENSG00000213281 ENST00000369535);
# ==============================================================================

my $args = construct_request(\@test_data); # warn Dumper $args;

my $response = dancer_response( POST => '/vep', $args ); # print_output($response);
response_status_is $response => 200; # exit;

response_content_like $response => qr(transcript db: core);
response_content_like $response => qr(N-Ras exon 3.1 \[233:T/A\]);
response_content_like $response => qr(Processed 1 vep input rows);
response_content_like $response => qr(Sample results for data src "data.txt" \[1\]);
response_content_like $response => qr(Sample match failures \[0\]);
response_content_like $response => qr(VEP results \[1\]);
response_content_like $response => qr(Non-CDS VEP results \[0\]);
# has core db Gene & Feature cols:
response_content_like $response => qr($_) for @core;
# doesn't have refseq db Gene & Feature cols:
response_content_unlike $response => qr($_) for @refseq;

{ # repeat with 'refseq' db selected:
    local $args->{params}->{db} = 'refseq';
    
    $response = dancer_response( POST => '/vep', $args ); # print_output($response);
    response_status_is $response => 200; # exit;

    response_content_like $response => qr(transcript db: refseq);
    response_content_like $response => qr(N-Ras exon 3.1 \[233:T/A\]);
    response_content_like $response => qr(Processed 1 vep input rows);
    response_content_like $response => qr(Sample results for data src "data.txt" \[1\]);
    response_content_like $response => qr(Sample match failures \[0\]);
    response_content_like $response => qr(VEP results \[2\]); # 1 more than core
    response_content_like $response => qr(Non-CDS VEP results \[0\]);
    
    # has refseq db Gene & Feature cols:
    response_content_like $response => qr($_) for @refseq;
    # doesn't have core db Gene & Feature cols:
    response_content_unlike $response => qr($_) for @core;
}

{ # repeat with 'merged' db selected:
    local $args->{params}->{db} = 'merged';
    
    $response = dancer_response( POST => '/vep', $args ); # print_output($response);
    response_status_is $response => 200; # exit;

    response_content_like $response => qr(transcript db: merged);
    response_content_like $response => qr(N-Ras exon 3.1 \[233:T/A\]);
    response_content_like $response => qr(Processed 1 vep input rows);
    response_content_like $response => qr(Sample results for data src "data.txt" \[1\]);
    response_content_like $response => qr(Sample match failures \[0\]);
    response_content_like $response => qr(VEP results \[3\]); # 1 more than core
    response_content_like $response => qr(Non-CDS VEP results \[0\]);
    
    # has both core & refseq db Gene & Feature cols:
    response_content_like $response => qr($_) for @refseq;
    response_content_like $response => qr($_) for @core;
}

done_testing;