use Test::More import => ['!pass'];

use strict;
use warnings;

use NGS with => {logger => 'file', log => 'error'}; # spare console from overload
use FindBin qw($Bin); # warn $Bin;
use Dancer2::Test apps => ['NGS'];
use Data::Dumper;
use Modern::Perl;

# sample match using separate data src file; repeat with 'coding_only' off:

# can pass data-file: 
my %files = (
#	data_file => 'A test string that will pretend to be file contents.',
	name => 'data_src',
	filename => $Bin .'/data/003_data.txt',
);

my %params = (
    check_existing => 1,
    coding_only    => 1,
    regulatory     => 1,
    data_src       => 'data.txt',
    polyphen       => 'b',
    sift           => 'b',
);

my $response = dancer_response( POST => '/vep', {
        headers => [ [ Content_Type => 'form-data' ] ],
        params  => \%params,
        files   => [ \%files ],
    }
); # warn Dumper $response->{content};

response_status_is $response => 200;

# ASXL exon 12.7 [120]
response_content_like $response => qr(ASXL exon 12.7 \[120:C/T\]);
response_content_like $response => qr(missense_variant);
response_content_unlike $response => qr(downstream_gene_variant);
response_content_like $response => qr(Processed 1 accepted rows);
response_content_like $response => qr(Sample results \[1\]);
response_content_like $response => qr(Sample match failures \[0\]);
response_content_like $response => qr(VEP results \[2\]);
response_content_like $response => qr(VEP orphans \[0\]);

# repeat with 'variants in coding regions only' off:
{
    local $params{coding_only} = 0;
    $response = dancer_response( POST => '/vep', {
        headers => [ [ Content_Type => 'form-data' ] ],
        params  => \%params,
        files   => [ \%files ],
    });
  
   response_content_like $response => qr(downstream_gene_variant);
   response_content_like $response => qr(VEP results \[4\]);
} # warn Dumper \%params;

done_testing;