use Test::More import => ['!pass'];

use NGS with => { logger => 'console', log => 'error' }; # spare console from overload
use FindBin qw($Bin); # warn $Bin;
use Dancer2::Test apps => ['NGS'];
use Data::Dumper;
use Modern::Perl;

require 't/test-lib.pl';

# 2 exons, 2 different samples:

# test data ====================================================================
my @test_data = (
    [
        'N-Ras exon 3.1',
        '233:T/A',
        'Accepted',
        51.1, 66,
        0, 66,
        51.1, 66,
    ],
    [
        'RUNX exon 4.1',
        '102:C/T',
        'Accepted',
        13.2, 66,
        13.2, 66,
        0, 66,
    ],
);
# ==============================================================================

my $args = construct_request(\@test_data);

my $response = dancer_response( POST => '/vep', $args ); # print_output($response);
response_status_is $response => 200; # exit;

response_content_like $response => qr(N-Ras exon 3.1 \[233:T/A\]);
response_content_like $response => qr(RUNX exon 4.1 \[102:C/T\]);
response_content_like $response => qr(Processed 2 vep input rows);
response_content_like $response => qr(Sample results for data src "data.txt" \[2\]);
response_content_like $response => qr(Sample match failures \[0\]);
response_content_like $response => qr(VEP results \[9\]);
response_content_like $response => qr(Non-CDS VEP results \[0\]);

done_testing;