# contains some common data structures for *.t:

use strict;
use warnings;

open my $fh, '>' . "./t/response.htm" or die $!;

sub construct_request {
    my $test_data = shift; # warn Dumper $test_data; # arrayref, or AoA

    my $params = _get_form_params(); # polyphen, sift, etc

    # emulate src data text file:
    my $file_header = _get_file_header($test_data); # warn Dumper $header;
    my $file_data = join "\n",
        ( join "\t", @$file_header ),
        ( join "\n", map { _make_row($_ ) } @$test_data ); # warn $file_data;

    my $files = _get_data_file();
    $files->{data} = $file_data;

    my %args = (
        headers => [ [ Content_Type => 'form-data' ] ],
        params  => $params,
        files   => [ $files ],
    );
    return \%args;
}

sub print_output {
    my $response = shift;
    print $fh $response->{content};  
}

sub _make_row {
    my $data = shift; # warn Dumper $data; # arrayref
    return join "\t", @$data
}

# returns col headers to match number of samples passed in $test_data:
sub _get_file_header {
    my $test_data = shift; # warn Dumper $test_data; # AoA

    my $dataset = @{$test_data}[0]; # warn Dumper $dataset; arrayref
    # no. of sampless = dataset size minus 5 (common cols) / 2 (results in col pairs):
    my $no_of_samples = ( scalar @$dataset - 5 ) / 2; # warn $no_of_samples;
    
    my @cols = qw(
        Reference
        Variant
        Status
        Max-combined-%
        Max-combined-of
    );
    
    push @cols, (
        "H$_/10-combined-%",
        "H$_/10-combined-of",
    ) for ( 1 .. $no_of_samples ); # H1/10, H2/10, etc
    # warn Dumper \@cols; 
    return \@cols;
}

sub _get_form_params {
    return {
        check_existing => 1,
        coding_only    => 1,
        regulatory     => 1,
        data_src       => 'data.txt',
        polyphen       => 'b',
        sift           => 'b',
    }
}

sub _get_data_file {
    return {
        filename => 'data.txt',
        name     => 'data_src',
        data     => undef, # created in construct_request using .t $data,
    }
}

1;