use Test::More import => ['!pass'];

use NGS with => { logger => 'console', log => 'error' }; # spare console from overload
use FindBin qw($Bin); # warn $Bin;
use Dancer2::Test apps => ['NGS'];
use Data::Dumper;
use Modern::Perl;

require 't/test-lib.pl';

# 2 samples for same row:

# test data ====================================================================
my @test_data = (
    [
        'ASXL exon 12.7',
        '120:C/T',
        'Accepted',
        100, 8,
        4.94, 81,
        100, 8,
    ],
);
# ==============================================================================

my $args = construct_request(\@test_data);

my $response = dancer_response( POST => '/vep', $args ); # print_output($response);
response_status_is $response => 200; # exit;

# K-Ras exon 2.1 [137] - VEP orphan
response_content_like $response => qr(ASXL exon 12.7 \[120:C/T\]); 
response_content_like $response => qr(Processed 1 accepted rows);
response_content_like $response => qr(Sample results for data src "data.txt" \[2\]);
response_content_like $response => qr(Sample match failures \[0\]);
response_content_like $response => qr(VEP results \[2\]);
response_content_like $response => qr(Non-CDS VEP results \[0\]);
response_content_like $response => qr(missense_variant);
response_content_like $response => qr(1/10);
response_content_like $response => qr(2/10);

done_testing;