# decimal in variant

use NGS::Test::Common; # imports all required modules (NGS, Plack::Test, etc)

my $app = NGS->to_app;
my $test = Plack::Test->create($app);

# test data ====================================================================
my @test_data = (
    # 'normal' variant; needed to avoid 'ERROR: Could not detect input file format':
    [
        'DNMT3A exon 15', 
        '41:G/T',
        'Accepted',
        11.6, 163,
        11.6, 163,
    ],
    # non-standard variant format:
    [
        'FLT3-ITD 1',
        'i(278.5,TGAGATCATATTCATATTTGAGATCATATTCATATT)', 
        'Accepted',
        11.6, 163,
        11.6, 163,
    ],
    # variant contains decimal (invalid base):
    [
        'NPM1 exon 12.1',	
        '133.5:--/CC', 
        'Accepted',
        11.6, 163,
        11.6, 163,
    ],
);
# ==============================================================================

my $content = create_content(\@test_data); # can return either array, or arrayref
my $response = $test->request( POST '/vep', @$content ); # print_response($response);
is( $response->code, 200, '[POST /vep] success' );

check_response( 'cannot split FLT3-ITD 1 variant' );
check_response( 'FLT3-ITD 1 | omitted from VEP input' );
check_response( 'DNMT3A exon 15 \[41:G/T\]' );
check_response( 'NPM1 exon 12.1 \[133.5:--/CC\]' );
check_response( 'Sample match failures \[2\]' );
check_response( 'Non-CDS VEP results \[2\]' );
check_response( '2 vep input rows' );
check_response( '3 accepted/filtered rows' );
check_response( '3 total source file rows' );

sub check_response { like( $response->content, qr(@_) ) }

done_testing;