package NGS::Test::Common;

BEGIN { # set test env otherwise development config settings loaded - unless explicitly
    $ENV{DANCER_ENVIRONMENT} ||= $ENV{PLACK_ENV} ||= 'test';
}

use base 'Import::Base';

# to suppress warning: 
#	Name "Import::Base::IMPORT_MODULES" used only once: possible typo 
$Import::Base::IMPORT_BUNDLES if 0;
$Import::Base::IMPORT_MODULES if 0;

# Modules that are always imported
our @IMPORT_MODULES = (
    'HTTP::Request::Common',
    'Modern::Perl',
    'Plack::Test',
    'NGS::Test',
    'IO::All',
    # modules with params:
    NGS => [
        with => { logger => 'LogReport', log => 'error', environment => 'test' },
    ],
	FindBin => [ qw($Bin) ],
    Test::More => [ import => ['!pass'] ],
);

# Named bundles to include
our %IMPORT_BUNDLES = (
    Debug => [ 'Data::Dumper', 'Data::Printer' ],
);

1;
