use Test::More import => ['!pass'];

use NGS with => { logger => 'console', log => 'error' }; # spare console from overload
use FindBin qw($Bin); # warn $Bin;
use Dancer2::Test apps => ['NGS'];
use Data::Dumper;
use Modern::Perl;

require 't/test-lib.pl';

# 2 exons producing same chr location and base substitution (2_25466888_G/T)
# 1 non-existant entry in ref table

# test data ====================================================================
my @test_data = (
    [
        'DNMT3A exon 15',	
        '41:G/T', # => 2_25466888_G/T
        'Accepted',
        11.6, 163,
        11.6, 163,
    ],
    [
        'DNMT3A exon 16',	
        '227:G/T', # => 2_25466888_G/T - overwrites DNMT3A exon 15 [41:G/T] entry
        'Accepted',
        11.6, 163,
        11.6, 163,
    ],
    [
        'DNMT3A exon 99',	# fictitious
        '29:G/T',
        'Accepted',
        11.6, 163,
        11.6, 163,
    ],
);
# ==============================================================================

my $args = construct_request(\@test_data);

my $response = dancer_response( POST => '/vep', $args ); # warn Dumper $response;
response_status_is $response => 200; # exit;

response_content_like $response => qr(no ref table entry for DNMT3A exon 99);
response_content_like $response => qr(DNMT3A exon 99 omitted from VEP input);
response_content_like $response => qr(DNMT3A exon 15 omitted from VEP input);
response_content_like $response => qr(DNMT3A exon 16 \[227:G/T\]);
response_content_like $response => qr(non-CDS); # not an exon region
response_content_like $response => qr(Processed 3 accepted rows);

done_testing;