use Test::More import => ['!pass'];

use NGS with => { logger => 'console', log => 'error' }; # spare console from overload
use FindBin qw($Bin); # warn $Bin;
use Dancer2::Test apps => ['NGS'];
use Data::Dumper;
use Modern::Perl;

require 't/test-lib.pl';

# mutation across > 1 base pair:

# test data ====================================================================
my @test_data = (
    [
        'ASXL exon 12.2',
        '144-145:AC/--',
        'Accepted',
        38.1, 21,
        38.1, 21,
    ],
);
# ==============================================================================

my $args = construct_request(\@test_data);

my $response = dancer_response( POST => '/vep', $args ); # print_output($response);
response_status_is $response => 200; # exit;

response_content_like $response => qr(ASXL exon 12.2 \[144-145:AC/--\]);
response_content_like $response => qr(Processed 1 accepted rows);
response_content_like $response => qr(Sample results for data src "data.txt" \[1\]);
response_content_like $response => qr(VEP results \[2\]);
response_content_like $response => qr(Non-CDS VEP results \[0\]);
response_content_like $response => qr(missense_variant);
response_content_like $response => qr(coding_sequence_variant);

done_testing;