use Test::More import => ['!pass'];

use NGS with => { logger => 'console', log => 'error' }; # spare console from overload
use FindBin qw($Bin); # warn $Bin;
use Dancer2::Test apps => ['NGS'];
use Data::Dumper;
use Modern::Perl;

require 't/test-lib.pl';

# sample match failure (synonymous_variant = rejected):

# test data ====================================================================
my @test_data = (
    [
        'p53 exon 9.5 NEW',
        '120:T/C',
        'Accepted',
        11.66, 163,
        11.66, 163,
    ],
);
# ==============================================================================

my $args = construct_request(\@test_data);

my $response = dancer_response( POST => '/vep', $args ); # print_output($response);
response_status_is $response => 200;

# p53 exon 9.5 NEW [120]
response_content_like $response => qr(p53 exon 9.5 NEW \[120:T/C\]);
response_content_like $response => qr(Processed 1 vep input rows);
response_content_like $response => qr(synonymous_variant);
response_content_like $response => qr(Sample results for data src "data.txt" \[0\]);
response_content_like $response => qr(Sample match failures \[1\]);
response_content_like $response => qr(VEP results \[7\]);
response_content_like $response => qr(Non-CDS VEP results \[0\]);

done_testing;