package NGS::ChartMaker;

use lib (
    '/home/raj/perl5/lib/perl5',
    '/home/raj/perl-lib/ChartDirector',
);

use Modern::Perl qw(2012); # 5.14

use perlchartdir;
use autodie;

use Moo;

use FindBin; # warn $FindBin::Bin;
use lib $FindBin::Bin . '/../lib'; # warn $FindBin::Bin;

use NGS::MooX::Types qw(HashReference VarChar);

has data => ( is => 'ro', isa => HashReference, required => 1);
has $_ => ( is => 'ro', isa => VarChar[25], required => 1) # VarChar max 25 chars
    for qw(data_title chart_title x_title y_title);

sub make_chart {
    my $self = shift;

    my $x_label  = $self->x_title;
    my $y_label  = $self->y_title;
    my $header   = $self->chart_title;
    my $data     = $self->data; # href of x & y

    my $img_name = $self->data_title;
    $img_name =~ s/\.vcf\Z//i; # remove vcf suffix if exists

    my $filename = sprintf '%s/analysis/%s.png', $FindBin::Bin, $img_name ;
    
	my $c = new XYChart(650, 420);

	$c->setPlotArea(75, 65, 550, 300, -1, -1, 0xc0c0c0, 0xc0c0c0, -1);

	$c->addTitle($header, 'timesbi.ttf', 18);

	$c->xAxis()->setTitle($x_label, 'arialbi.ttf', 12);
	$c->yAxis()->setTitle($y_label, 'arialbi.ttf', 12);

	$c->xAxis()->setWidth(2);
	$c->yAxis()->setWidth(2);

	$c->addScatterLayer($data->{x}, $data->{y}, undef, # data label not required
		$perlchartdir::CircleShape, 4, 0xff0000);

	$c->makeChart($filename);
}

1;
