# core vs refseq vs merged transcription dbs (merged only v76+):

use NGS::Test::Common; # imports all required modules (NGS, Plack::Test, etc)

my $app = NGS->to_app;
my $test = Plack::Test->create($app);

# test data ====================================================================
my @test_data = (
    [
        'N-Ras exon 3.1',
        '233:T/A',
        'Accepted',
        51.1, 66,
        0, 66,
        51.1, 66,
    ],
);

# core & refseq Gene & Feature cols:
my @refseq = qw(CCDS877.1 NM_002524.4 4893);
my @core   = qw(ENSG00000213281 ENST00000369535);
# ==============================================================================

my $content = create_content(\@test_data); # can return either array, or arrayref
my $response = $test->request( POST '/vep', @$content ); # print_response($response);
is( $response->code, 200, '[POST /vep] success' );

check_response( $response->content, 'transcript db: core' );
check_response( $response->content, 'N-Ras exon 3.1 \[233:T/A\]' );
check_response( $response->content, 'Processed 1 vep input rows' );
check_response( $response->content, 'Sample results for data src "data.txt" \[1\]' );
check_response( $response->content, 'Sample match failures \[0\]' );
check_response( $response->content, 'VEP results \[1\]' );
check_response( $response->content, 'Non-CDS VEP results \[0\]' );
# has core db Gene & Feature cols:
check_response( $response->content, $_ ) for @core;
# doesn't have refseq db Gene & Feature cols:
check_response_not( $response->content, $_ ) for @refseq;

{ # repeat with 'refseq' db selected:
    my $content = create_content(\@test_data, 'refseq');

    my $response = $test->request( POST '/vep', @$content ); # print_response($response);
    is( $response->code, 200, '[POST /vep] success' );

    check_response( $response->content, 'CCDS877.1 | not in transcripts db' );
    check_response( $response->content, '4893 | not in transcripts db' );
    check_response( $response->content, 'transcript db: refseq' );
    check_response( $response->content, 'N-Ras exon 3.1 \[233:T/A\]' );
    check_response( $response->content, 'Processed 1 vep input rows' );
    check_response( $response->content, 'Sample results for data src "data.txt" \[1\]' );
    check_response( $response->content, 'Sample match failures \[0\]' );
    check_response( $response->content, 'VEP results \[2\]' ); # 1 more than core
    check_response( $response->content, 'Non-CDS VEP results \[0\]' );

    # has refseq db Gene & Feature cols:
    check_response( $response->content, $_ ) for @refseq;
    # doesn't have core db Gene & Feature cols:
    check_response_not( $response->content, $_ ) for @core;
}

{ # repeat with 'merged' db selected:
    my $content = create_content(\@test_data, 'merged');

    my $response = $test->request( POST '/vep', @$content ); # print_response($response);
    is( $response->code, 200, '[POST /vep] success' );

    check_response( $response->content, 'transcript db: merged' );
    check_response( $response->content, 'N-Ras exon 3.1 \[233:T/A\]' );
    check_response( $response->content, 'Processed 1 vep input rows' );
    check_response( $response->content, 'Sample results for data src "data.txt" \[1\]' );
    check_response( $response->content, 'Sample match failures \[0\]' );
    check_response( $response->content, 'VEP results \[3\]' ); # 1 more than core
    check_response( $response->content, 'Non-CDS VEP results \[0\]' );

    # has both core & refseq db Gene & Feature cols:
    check_response( $response->content, $_ ) for @refseq;
    check_response( $response->content, $_ ) for @core;
}

# NB: global $response gets replaced in each block !!
sub check_response {
    my ($content, $pattern) = @_;
    like( $content, qr($pattern) );
}
sub check_response_not {
    my ($content, $pattern) = @_;
    unlike( $content, qr($pattern) );
}

done_testing(41);
