#!/usr/bin/env perl

# populate locations.sqlite db with content of __DATA__

use FindBin qw($Bin); # warn $FindBin::Bin;
use Modern::Perl;
use Data::Printer;
use Data::Dumper;
use Path::Tiny;

use lib '/home/raj/perl-lib';
use Local::DB;

my $db = path($Bin, '..', 'ngs.sqlite')->realpath; # warn 'DB:'. $db;
my $dsn = "dbi:SQLite:dbname=$db";

my $dbix = Local::DB->dbix({ dsn => $dsn }); # p $dbix;

my @rows = split "\n", do { local $/; <DATA> }; # p @rows; exit;
my @cols = qw( position action );

my %h;
ROW: for my $row(@rows) { # warn Dumper $row; # $row = tab-delimited string
    @h{@cols} = split ",", $row; # p %h; # next ROW; # pulls 1st 3 cols
    do { print "skipping $h{position} - already exists\n" and next ROW } if
        $dbix->select('locations', 1,
            { position => $h{position}, action => $h{action} })->list; # p %h;
    $dbix->insert('locations', \%h) or die $dbix->error;
}

__DATA__
43815009,include
115256528,include
115256529,include
115256530,include
115256532,include
115258744,include
115258745,include
115258747,include
115258748,include
25457176,include
25457209,include
25457242,include
25457243,include
25458627,include
25458649,include
25458669,include
25458696,include
25463184,include
25463248,include
25463286,include
25463287,include
25463541,include
25463562,include
25464457,include
25467083,include
25467134,include
25467436,include
25467449,include
25470498,include
25470516,include
25470535,include
198266834,include
198267359,include
198267360,include
198267361,include
198267371,include
198267373,include
198267483,include
198267484,include
198267491,include
209113112,include
209113113,include
55599320,include
55599321,include
55599340,include
106156246,include
106156348,include
106156478,include
106156687,include
106156729,include
106156747,include
106156963,include
106157002,include
106157167,include
106157212,include
106157240,include
106157404,include
106157527,include
106157845,include
106157971,include
106157995,include
106164061,include
106164778,include
106182940,include
106193748,include
106193778,include
106193853,include
106193892,include
106193931,include
106196213,include
106196556,include
148506443,include
5073770,include
32413565,include
32413566,include
119148990,include
119148991,include
25380275,include
25398281,include
25398284,include
25398285,include
28592622,include
28592623,include
28592640,include
28592641,include
28592642,include
28602329,include
28602340,include
28609758,include
90631838,include
90631934,include
90631935,include
7578190,include
74732959,include
74732960,include
74732961,include
31021250,include
31021472,include
31022277,include
31022288,include
31022592,include
31022839,include
31022847,include
31022902,include
31022988,include
31023408,include
36231773,include
36231782,include
36231783,include
36252865,include
36252866,include
36252877,include
36259171,include
36259172,include
44514777,include
44514780,include
44524456,include
