# contains some common data structures for *.t:

sub construct_request {
    my $test_data = shift; # warn Dumper $test_data; # arrayref, or AoA
    
    my $params = _get_form_params(); # polyphen, sift, etc

    # emulate src data text file:
    my $file_header = _get_file_header(); # warn Dumper $header;
    my $file_data = join "\n",
        ( join "\t", @$file_header ),
        ( join "\n", map { _make_row($_ ) } @$test_data ); # warn $file_data;

    my $files = _get_data_file();
    $files->{data} = $file_data;

    my %args = (
        headers => [ [ Content_Type => 'form-data' ] ],
        params  => $params,
        files   => [ $files ],
    );
    return \%args;
}

sub _make_row {
    my $data = shift; # warn Dumper $data; # arrayref    
    return join "\t", @$data
}

sub _get_file_header {
    return [
        qw(
            Reference
            Variant
            Status
            Max-combined-%
            Max-combined-of
            H1/10-combined-%
            H1/10-combined-of
        )
    ];
}

sub _get_form_params {
    return {
        check_existing => 1,
        coding_only    => 1,
        regulatory     => 1,
        data_src       => 'data.txt',
        polyphen       => 'b',
        sift           => 'b',
    }
}

sub _get_data_file {
    return {
        filename => 'data.txt',
        name     => 'data_src',
        data     => undef, # created in construct_request using .t $data,
    }
}

1;