use Test::More tests => 6;
use strict;
use warnings;

# the order is important
use NGS with => {logger => 'console', log => 'error'};
use Dancer2::Test apps => ['NGS'];

route_exists [GET => '/'], 'a route handler is defined for /';
response_status_is ['GET' => '/'], 200, 'response status is 200 for /';

route_exists [GET => '/vep'], 'a route handler is defined for /vep';
response_status_is ['GET' => '/vep'], 200, 'response status is 200 for /vep';

route_doesnt_exist [GET => '/foo'], 404, 'a route handler is not defined for /foo';
response_status_is ['GET' => '/foo'], 404, 'response status is 404 for /foo';
