use Test::More import => ['!pass'];

use strict;
use warnings;

use NGS with => {logger => 'console', log => 'error'}; # spare console from overload
use FindBin qw($Bin); # warn $Bin;
use Dancer2::Test apps => ['NGS'];
use Data::Dumper;
use Modern::Perl;

route_exists [GET => '/'], 'a route handler is defined for /';
response_status_is [GET => '/vep'], 200, 'response status is 200 for /';

# can pass data-file: 
my %files = (
	name => 'data_src',
	filename => $Bin .'/data/004_data.txt',
);

my %params = (
    check_existing => 1,
    coding_only    => 1,
    regulatory     => 1,
    data_src       => '004_data.txt',
    polyphen       => 'b',
    sift           => 'b',
);

my $response = dancer_response( POST => '/vep', {
        headers => [ [ Content_Type => 'form-data' ] ],
        params  => \%params,
        files   => [ \%files ],
    }
); # warn Dumper $response->{content};

response_status_is $response => 200;

# RUNX exon 4.1 [89] - VEP orphan
response_content_like $response => qr(RUNX exon 4.1 \[89\]);
response_content_like $response => qr(Processed 1 accepted rows);
response_content_like $response => qr(Sample results \[0\]);
response_content_like $response => qr(Sample match failures \[1\]);
response_content_like $response => qr(VEP results \[0\]);
response_content_like $response => qr(VEP orphans \[1\]);
response_content_unlike $response => qr(variant); # none

done_testing;