# tests $filename file upload, initially invalid, then valid:

use NGS::Test::Common; # imports all required modules (NGS, Plack::Test, etc)

my $app = NGS->to_app;
my $test = Plack::Test->create($app);

say '###################################';
say "this test may take some time .....";
say '###################################';

{ # invalid lab number formats:
    my @files = ( '123456-12.vcf', '12345-125.vcf' );
    for my $filename ( @files ) {
        my @content = content_with_static_file($filename); # can return either array, or arrayref

        my $response = $test->request( POST '/vep', @content ); # print_response($response);
        is( $response->code, 200, '[POST /vep] success' );
        # like( $response->content, qr/Internal Server Error/ ); # not fatal any more
        like( $response->content, qr/incorrect lab number format/ );
    }
}
{ # invalid filename:
    my $filename = 'single.vcf';
    my @content = content_with_static_file($filename); # can return either array, or arrayref

    my $response = $test->request( POST '/vep', @content ); # print_response($response);
    is( $response->code, 200, '[POST /vep] success' );
    # like( $response->content, qr/Internal Server Error/ ); # not fatal any more
    like( $response->content, qr/filename format error/ );
}
{ # valid filename:

    my $filename = '874-12.vcf';
    my @content = content_with_static_file($filename); # can return either array, or arrayref

    my $response = $test->request( POST '/vep', @content ); # print_response($response);
    like( $response->content, qr/Sample results for data src "$filename" \[5\]/);

    like( $response->content, qr/$_/ ) for (
#        qq!Sample results for data src "$filename" \[5\]!, #  doesn't match - wtf??
        'Processed 5 vep input rows',
        '5 accepted/filtered rows',
        '8 total source file rows',
        'sample match failures \[0\]',
        'VEP results \[23\]',
        'non-CDS \[0\]',
    );
}

done_testing(13);
