# lab number misformat

use NGS::Test::Common; # imports all required modules (NGS, Plack::Test, etc)

my $app = NGS->to_app;
my $test = Plack::Test->create($app);

# test data ====================================================================
my @test_data = (
    [
        'ASXL exon 12.7',
        '120:C/T',
        'Accepted',
        100, 8,
        4.94, 81,
        100, 8,
    ],
);
# ==============================================================================

my @content = create_content(\@test_data); # can return either array, or arrayref

{ # remove '/' from 1st lab number - rewrite src data file:
    my $data_file = data_file_path();
    my $contents = io($data_file)->slurp; # warn Dumper $content;
    $contents =~ s/1\/10/110/g; # warn Dumper $content;
    # write edited content back to data file:
    io($data_file)->print($contents);
}

my $response = $test->request( POST '/vep', @content ); # print_response($response);
is( $response->code, 200, '[POST /vep] success' );

check_response( 'ASXL exon 12.7 \[120:C/T\]' );
check_response( 'Processed 1 vep input rows' );
check_response( 'Sample results for data src "data.txt" \[1\]' );
check_response( 'cannot find lab number in col header' );
check_response( 'Sample match failures \[0\]' );
check_response( 'VEP results \[2\]' );
check_response( 'Non-CDS VEP results \[0\]' );

sub check_response { like( $response->content, qr(@_) ) }

done_testing;