#!/usr/bin/env perl

use feature 'say';
say "Perl version: $^V";

use strict;
use warnings;

use FindBin;
use Devel::Confess 'color'; # to get full stacktrace instead of "eval nnn line nnn" in console; using 'traces' in .yml now
use Plack::Builder;

use lib "$FindBin::Bin/../lib";
use Routes;

builder {
	enable 'ReverseProxy'; # or set behind_proxy: 1 in app's D2 config

	mount '/moongate' => Routes->to_app; # for deployment
	mount '/'         => Routes->to_app; # for dev
}

=begin
# use this block if you don't need middleware, and only have a single target Dancer app to run here

use Moongate;
Moongate->to_app;
=cut

=begin comment
# use this block if you want to include middleware such as Plack::Middleware::Deflater

use Moongate;
use Plack::Builder;

builder {
	enable 'Plack::Middleware::AccessLog', # disable default using "plackup --no-default-middleware"
		# format => '%h %l %u %t "%r" %>s %b "%{Referer}i" "%{User-agent}i"';
        format => '%t "%r" %>s %b "%{Referer}i"';
	enable 'StackTrace'; # if switched off using "plackup --no-default-middleware"
	enable 'Lint';       # if switched off using "plackup --no-default-middleware"
    Moongate->to_app;
}

=cut

=begin comment
# use this block if you want to mount several applications on different path

use Moongate;
use Moongate_admin;

use Plack::Builder;

builder {
    mount '/'      => Moongate->to_app;
    mount '/admin'      => Moongate_admin->to_app;
}

=cut
