use App::Class;

class App::Model {
	use App::DB;

	use Path::Tiny;
	use Git::Wrapper;
	use Crypt::PBKDF2;
	use Data::Printer;

	field $cfg :reader :param; # required param
	field $git :reader = Git::Wrapper->new( $cfg->{appdir} );
	field $db  :reader = App::DB->new( cfg => $cfg );

	method find_user ($username) { $db->find_user($username) }

    method verify_password ($pwd, $hash) {
        Crypt::PBKDF2->new->validate($hash, $pwd); # using defaults for new()
    }

	# total number of records:
	method total_count { $self->db->total_count }

	# app version = number of git log commits:
    method version { return $git->log } # size of log

	method save_document ($data) {
		my $result = $self->db->save_document($data); # p $result;
        return $result;
	}

    method get_document ($id) {
        my $result = $self->db->get_document($id); # p $result;
        return $result;
    }

	method get_all { $self->db->get_all }

    method find_documents ($str) {
 		my $result = $self->db->find_documents($str); # p $result;
        return $result;
    }

	method gitlog { # using Git::Wrapper;
		my $n = $git->log; # say $n; # log() as scalar returns no. of log entries

		my @args  = qw( --no-merges --date=relative );
		my @dates = $git->RUN( qw/log --pretty=format:%ad/, @args);   # p @dates;
		my @msgs  = $git->RUN( qw/log --pretty=format:%s/,  $args[0]); # p @msgs;

		my @log = map { date => $dates[$_], msg => $msgs[$_] }, 0 .. $n - 1; # p @log;
		return \@log;
	}
}
