package LogReport;

use Log::Report ();
use Data::Printer;

use Dancer2;
use Dancer2::Plugin::LogReport;
use Model;

our $VERSION = '0.1';

hook before_template => sub {
	# p session;
};

get '/' => sub { template 'index', {}, { layout => 'index' } };

get '/test' => sub { template 'test' };

get '/update' => sub {
	# Log a debug message (console only):
	trace 'started function update()';

    my %values = (
		description => param('description'),
		title       => param('title'),
    );
    # if ( Model->update(\%values) ) { # relies on return value; error redirects to '/'
    if ( process sub { Model->update(\%values) } ) { # doesn't need return value & avoids redirect
	    success 'Success: update OK'; # console and tt output
	}
    else { # only get here if process() used above, otherwise error in update redirects to '/'
        # warning "update failed"; # don't need this - it's set in update()
    }

    notice 'about to render template ....';
  	template 'test';
};

get '/success' => sub { # console and tt output
    # Send a routine notice to the end user
	my $msg = Model->messages('success');
    success $msg;
  	template 'test';
};

get '/notice' => sub { # console and tt output
    # Send a routine notice to the end user
	my $msg = Model->messages('notice');
    notice $msg; # p config;
  	template 'test';
};

get '/mistake' => sub { # console and tt output
	# Warn the user (not fatal)
	my $msg = Model->messages('mistake');
	mistake $msg;
  	template 'test';
};

get '/assert' => sub { # console only, no tt output
	my $msg = Model->messages('assert');
    assert $msg;
  	template 'test';
};

get '/info' => sub { # console only, no tt output
	my $msg = Model->messages('info');
    info $msg;
  	template 'test';
};

get '/warning' => sub { # console and tt output
	my $msg = Model->messages('warning');
    warning $msg;
  	template 'test';
};

# 'FAULT', 'ALERT', 'FAILURE', 'PANIC' all fatal errors:
  # failure "Failure: something failed"; # not recognised
  # fault "Fault: a fault has occured"; # not recognised

get '/error' => sub { # redirects to '/'
	my $msg = Model->messages('error');
	error $msg; template 'test';
};
get '/alert' => sub { # redirects to '/'
	my $msg = Model->messages('alert');
    alert $msg; template 'test';
};
get '/panic' => sub { # redirects to '/'
	my $msg = Model->messages('panic');
	panic $msg; template 'test';
};
get '/fault' => sub { # redirects to '/'
	my $msg = Model->messages('fault');
    fault $msg; template 'test';
};
get '/failure' => sub { # redirects to '/'
	my $msg = Model->messages('failure');
    failure $msg; template 'test';
};

true;
