package Model;

use Log::Report;
use Data::Printer;

sub update {
    my ($self, $values) = @_; # p $values;
    $values->{title} or error 'please enter a title'; # will halt app
    $values->{description} or warning 'no description entered'; # doesn't halt app
    # do something here, only need return value if NOT using process():
    return ( $values->{title} && $values->{description} );
}

sub messages {
    my ($self, $type) = @_; # p $type;
    my %h = (
        failure     => 'Failure: something bad happened',
        warning     => 'Warning: this is a warning',
        mistake     => 'Mistake: this is a mistake',
        success     => 'Success: a success message',
        notice      => 'Notice: this is a notice',
        assert      => 'Assert: an assertion',
        error       => 'Error: this is an error',
        alert       => 'Alert: this is an alert',
        panic       => 'Panic: something very bad happened',
        fault       => 'Fault: something happened',
        info        => 'Info: some information',
    );
    return $h{$type} or error 'no such entry: ' . $type;
}

1;
