use LogReportTest;
use Data::Dumper;
use Data::Printer;
use Model;

sub debug {
    my $response = shift;  p $response->text;
    print_output($response);
}

my $psgi_app = LogReport::runner()->psgi_app;
LWP::Protocol::PSGI->register($psgi_app);
my $mech = Test::WWW::Mechanize->new;

my @types = (
    qw/notice mistake warning error alert fault failure success panic/
); # assert & info don't appear in tt

for my $type (@types) {
    next if $type eq 'panic'; # causes stack-trace in console
    my $msg = Model->messages($type);
    $mech->get('http://localhost/'.$type);                      #  debug($mech);
    $mech->text_contains($msg);
}

SKIP: { # panic - get stack trace even on test - can't set 'accept' in .yml above PANIC
    skip('console stack trace',0);
    $mech->get('http://localhost/panic');                        # debug($mech);
    $mech->text_contains(
        'An unexpected error has occurred',
        'Text contains: An unexpected error has occurred [panic; redirected]'
    );
}
{ # update without request param description:
    $mech->get('http://localhost/update?title=foo');             # debug($mech);
    $mech->text_contains('no description entered');
    $mech->text_contains('Success: update OK');
    $mech->text_contains('about to render template ....');
}

done_testing();
