# set $no_show_errors value true so LogReportTest loads test-no-errors.yml config
BEGIN { our $no_show_errors = 1 };

use LogReportTest;
use Data::Printer;
use Model;

my $mech = Test::WWW::Mechanize->new;
LWP::Protocol::PSGI->register( LogReport::app->to_app );

sub debug {
    my $response = shift; # p $response->text;
    print_output($response);
}

{
    my @types = ( qw/alert fault failure/ ); # error doesn't show default msg
    for my $type (@types) {
        $mech->get('http://localhost/'.$type);                   # debug($mech);              
        $mech->text_contains(
            'An unexpected error has occurred',
            "Text contains: An unexpected error has occurred [$type; redirected]",
        );
        $mech->has_tag( h1 => 'Perl is dancing' ); # proves re-direct to '/'
    }
    { # error loads msg from model but still redirects:
        $mech->get('http://localhost/error');                   #  debug($mech);
        my $msg = Model->messages('error');
        $mech->text_contains($msg);
        $mech->has_tag( h1 => 'Perl is dancing' ); # proves re-direct to '/'
    }
}

done_testing();
