# tests 2 methods of returning object by Local::DB

use FindBin;
use 5.26.0;

use lib $FindBin::Bin . '/..'; # to find Local::
use Local::DB;

say '=' x 80;

# 1) Local::DB returns sub-classed query() & _replace_omniholder() methods:
{
	my $dbix = Local::DB->dbix('hilis4'); # calls dbix()
	run($dbix);
}

say '=' x 80;

# 2) Local::DB does NOT return sub-classed query() & _replace_omniholder() methods:
{
	my $dbix = Local::DB->_dbix('hilis4'); # calls _dbix()
	run($dbix);
}
say '=' x 80;

sub run {
	my $dbix = shift;
	say 'Local::DB isa ' . ref $dbix;

	my $query = q!select count(*) from users where id in (??) and active = ?!;
	my $result = eval { $dbix->query($query, 1, 2, 3, 'yes')->list };
	say 'query result=' . _quote( $result || $dbix->error );
}
sub _quote { sprintf q!"%s"!, $_[0] }
