package Local::SQL::Abstract::Plugin::InsertMulti;

# extends SQL::Abstract::Plugin::InsertMulti to add method replace_multi()

use strict;
use warnings;
 
# use Data::Printer;
use SQL::Abstract::Plugin::InsertMulti;

use Sub::Exporter -setup => +{
    into    => 'SQL::Abstract',
    exports => [ qw/replace_multi insert_ignore_multi update_or_insert_multi/ ],
    groups => {
        default => [ qw/replace_multi insert_ignore_multi update_or_insert_multi/ ]
    },
};

sub replace_multi {
	my ($self, @args) = @_;
	my ($sql, @bind) = $self->insert_multi(@args); # warn $sql;
	$sql =~ s/^INSERT/REPLACE/; 
	return wantarray ? ( $sql, @bind ) : $sql;
}

sub insert_ignore_multi {
	my ($self, @args) = @_;
	my ($sql, @bind) = $self->insert_multi(@args); # warn $sql;
	$sql =~ s/^INSERT/INSERT IGNORE/; 
	return wantarray ? ( $sql, @bind ) : $sql;    
}

# needs list of cols passing as 4th arg, for a=VALUES(a), b=VALUES(b), etc
sub update_or_insert_multi {
	my ($self, @args) = @_;
	die 'no cols specified for ON DUPLICATE KEY UPDATE list' unless @args == 4;
	my $odku = pop @args; # p $odku;
	
	my ($sql, @bind) = $self->insert_multi(@args);
	$sql .= ' ON DUPLICATE KEY UPDATE ' 
		. join ', ', map { "`$_`=VALUES(`$_`)" } @$odku; # warn $sql;
	return wantarray ? ( $sql, @bind ) : $sql;    
}

1;