use Test::More; # see done_testing()
use Test::Deep; # eq_deeply()

use Data::Printer;
use Data::Dumper;
use Modern::Perl;
use Path::Tiny;
use DateTime;

use FindBin qw($Bin); # warn $Bin;
use lib '/home/raj/perl-lib';

require_ok( 'Local::Utils' );

my $dt1 = DateTime->now;
my $dt2 = DateTime->now->subtract(days => 1);

{ # stringify DT object:
	my $to_string = Local::Utils::datetime_to_string($dt1);
	is( $to_string, $dt1->datetime );
}
{ # stringify hashref of DT objects:
	my %h = (
		foo => $dt1,
		bar => $dt2,
	);
	my $ref = Local::Utils::datetime_to_string(\%h); # p $ref;
	is_deeply( $ref, { foo => $dt1->datetime, bar => $dt2->datetime });
}
{ # stringify HoH of DT objects:
	my %h = (
		foo => {
			bar => $dt1,
			baz => $dt2,
		},
	);
	my $ref = Local::Utils::datetime_to_string(\%h); # p $ref;
	is_deeply( $ref, { foo => { bar => $dt1->datetime, baz => $dt2->datetime } });
}
done_testing(4);