package Local::SendGrid;

# todo: validation on supplied 'msg' hashref 

use 5.34.0;

use Moo;
use IO::All;
use Data::Printer;
use Email::SendGrid::V3;
use Types::Standard qw(HashRef); # Str ArrayRef  Object

has msg => ( is => 'ro', isa => HashRef, required => 1 );

# ZBOX Ubuntu 22.04 key:
my $api_key = io('/home/raj/.local/sendgrid_api_key')->slurp 
	|| die 'no api key'; # say $api_key;
# default e-mail to/from:
my $self_addr = io('/home/raj/.local/email_address')->slurp 
	|| die 'no default email addess'; # say $api_key;

sub send {
	my $msg = shift->msg; # p $msg;
	
	$msg->{from} ||= $self_addr;
	$msg->{to}   ||= $self_addr;
	
	my $sg = Email::SendGrid::V3->new( api_key => $api_key )
		->from( $msg->{from} )
		->subject( $msg->{subject} )
		->add_content( 'text/plain', $msg->{text} )
		->add_envelope( to => [ $msg->{to} ] );
	# optional functions; sandbox tests message for compliance, does not send
	$sg->sandbox_mode(1) if $msg->{test_only};
	$sg->footer(1, %{ $msg->{footer} }) if $msg->{footer};
		# p $sg;
	my $result = $sg->send; # p $result;
	return $result->{success}
		? "Email success" : "Email failure: " . $result->{reason};
}