# Apache benchmark tests of Gazelle, Starman, Twiggy, Corona & HTTP::Server::Simple
# using hello.psgi [https://blog.sparsh.dev/ab-apache-benchmark-load-testing/]

# results measured on Ubuntu 22.04 VM; ZBOX much slower

=begin
need to create Plack::Runner starter scripts for HTTP::Server::Simple and Gazelle
in ~/perl5/bin to match installed starman & twiggy scripts; see ~/perl5/bin/twiggy
for details

in 2 terminals:
  1) start_server --port 8000 -- [starman|twiggy|gazelle] --workers 32 hello.psgi
  2) ab -n 100000 -c 10 -k http://127.0.0.1:8000/

* gazelle: 14084.74 [#/sec] (mean)
* starman:  9582.31 [#/sec] (mean)
* twiggy:   6756.85 [#/sec] (mean)

Corona and HTTP::Server::Simple cannot be run using start_server, use: 
  [corona|gazelle|starman|twiggy|http-server-simple] --listen :8000 hello.psgi
* gazelle: 13925.93 [#/sec] (mean)
* starman:  8479.88 [#/sec] (mean)
* twiggy:   6818.50 [#/sec] (mean)
* h-s-s:    3160.82 [#/sec] (mean)
* corona:   1841.03 [#/sec] (mean)
 
plackup -s Foo much slower, maybe due to stdout (not present for server_starter)
plackup -s [Gazelle|Twiggy|Starman|Corona] --port 8000 -a hello.psgi
   gazelle: 3327.89 [#/sec] (mean)
   starman: 2940.78 [#/sec] (mean)
   twiggy:  2657.35 [#/sec] (mean)
   corona:  1723.29 [#/sec] (mean)
   h-s-s:   1357.92 [#/sec] (mean)

suppressing stdout using "/dev/null 2>&1" is faster:
plackup -s [Gazelle|Twiggy|Starman|Corona] --port 8000 -a hello.psgi >> /dev/null 2>&1
	gazelle: 6371.15 [#/sec] (mean)
	starman: 5651.10 [#/sec] (mean)
	twiggy:  4637.74 [#/sec] (mean)
	corona:  3216.69 [#/sec] (mean)
	h-s-s:   2574.33 [#/sec] (mean)
=cut

my $handler = sub {
    return [ 
		200, [ "Content-Type" => "text/plain", "Content-Length" => 11 ], 
		[ "Hello World" ] 
	];
};