package Local::Calendar;

use Moo; # use strict & warnings auto
use Date::Calendar; # considers public hols
use Date::Calendar::Profiles qw( $Profiles ); # warn Dumper $Profiles->{GB};

use Data::Printer alias => 'ddp';
use Local::Types qw(DateCalendar);

# use Types::Standard qw(InstanceOf); # using Local::Types (Type::Library class) now
# has calendar => ( isa => InstanceOf['Date::Calendar'], is => 'lazy' );
has calendar => ( isa => DateCalendar, is => 'lazy' );

sub delta_workdays {
	my $self = shift;
    my ( $d0, $d1 ) = @_;

    my @d0 = split '-', $d0; # ddp @d0;
    my @d1 = split '-', $d1; # ddp @d1;

    # use date-1, date-2, flags 1, 0 for equivalence to Date::Calc result
    my $calendar = $self->calendar();
	my $delta = $calendar->delta_workdays(\@d0, \@d1, 1, 0); # flags 1 & 0
    return $delta;
}

sub _build_calendar { # warn 'building Date::Calendar object'; # should only hit once
    my $profile = $Profiles->{GB}; # ddp $profile; # hashref of UK holiday dates
        # $profile->{HollyDay} = '2/Mon/Feb'; # ficticous holiday (eg 2nd Mon in Feb) to test
    my $calendar = Date::Calendar->new($profile);
	# ddp $calendar;

=begin # check dates - Easter Sunday calculated in Date::Calc::PP::DateCalc_easter_sunday():
warn $calendar->is_full($_) for (
    [2013,1,1],   # NYD
    [2013,3,29],  # Easter Fri
    [2013,4,1],   # Easter Mon
    [2013,5,6],   # May Day
    [2013,5,27],  # Spring Bank
    [2013,8,26],  # Summer Bank
    [2013,12,25], # Xmas
    [2013,12,26], # Boxing Day

    [2010,12,25], # Xmas - Sat
    [2010,12,26], # Boxing Day - Sun
    [2010,12,27], # Mon - should be holiday
    [2010,12,28], # Tues - should be holiday
    [2010,12,29], # Weds - should not be holiday
);
=cut
    return $calendar;
}

1;