package Local::Utils;

use strict;
use warnings;

use HTML::Escape;
use Data::Printer;

sub symbolise { # transform eg 10/9/l & /ul
    my $string = shift || return; # warn $string;

    my $formatted = HTML::Escape::escape_html($string); # p $formatted;

    $formatted =~ s/(\d)\/ul/$1\/&micro;L/ig;    # /ul
    $formatted =~ s/10\/(6|9)\/(l|kg)/10<sup>$1<\/sup>\/$2/ig; # 10/9/l; 10/6/kg; etc
    $formatted =~ s/10\^(\d)/10<sup>$1<\/sup>/g;         # 10^6; 10^9; etc
		# p $formatted;
    return $formatted;
}

1;