package Local::QueryLogger;

# TODO - apache fastcgi process can't find location of calling apps' logs dir
# creates 2 files, '%d{yyyy_MMdd}_sql.log' with 0660 permissions, another with
# todays date but 644 permissions (apache fastcgi process can't create this one)

use DateTime;
use Data::Printer;
use FindBin qw($Bin); # warn $Bin;
use Log::Dispatch::File::Rolling;

use Moo;
use Local::MooX::Types qw(String);

our $CurrentUsername; # set later on login

# my $today = DateTime->today->ymd;
my $dispatcher = Log::Dispatch->new;

# development:
$dispatcher->add(
    Log::Dispatch::File->new(
        permissions => 0600,
        min_level   => 'info',
        filename    => 'logs/devel.sql',
        newline     => 0,
        name        => 'devel',
        mode        => 'append',
    )
);
# deployment:
$dispatcher->add(
    Log::Dispatch::File::Rolling->new(
        permissions => 0660,
        min_level => 'info',
        # filename  => "logs/${today}_sql.log", # will be relative to start script dir
        filename  => 'logs/%d{yyyy_MMdd}.sql', # will be relative to start script dir
        newline     => 0,
        name      => 'deployment',
        mode      => 'append',
    )
);

=begin # Log::Dispatch::FileWriteRotate:
use Log::Dispatch::FileWriteRotate;
$dispatcher->add(
    Log::Dispatch::FileWriteRotate->new(
        min_level => 'info',

        # will be passed to File::Write::Rotate
        dir       => '/home/raj/apps',
        prefix    => 'query',
        suffix    => '.log',
        period    => 'daily',
        size      => 25*1024*1024,
        histories => 1000, # 0 keeps no histories
    )
);
=cut

sub log {
    my ($self, $name, $level, $msg) = @_; # ddp $name; ddp $msg; # ddp $level;
    if ($CurrentUsername) { # will only exist if app has login & session
        $msg = join ' ', uc $CurrentUsername, $msg; # prepend username
    } # ddp $CurrentUsername; ddp $name; ddp $msg;
    $dispatcher->log_to(name => $name, level => $level, message => $msg);
}

1;
