package Local::MultiExporter;

use strict;
use warnings;

use Import::Into;

sub import {
    my $target = caller;

    require feature;
    feature->import( qw/say switch given/ );
    require autodie;
    autodie->import;

  # without Moo:
    # require strict;   # strict->import;
    # require warnings; # warnings->import;

    Moo->import::into($target);
    FindBin->import::into($target, '$Bin');
    Path::Tiny->import::into($target); # $data = path('foo.txt')->slurp/slurp_raw/slurp_utf8;
    List::Util->import::into($target, qw/min max first any all/);
    Carp::Always->import::into($target);
    Local::Utils->import::into($target);
    match::simple->import::into($target); # if ($foo |M| $bar)
    Data::Printer->import::into($target);
    Types::Standard->import::into($target,
        qw/Num Str ArrayRef HashRef Object InstanceOf/);
    Syntax::Keyword::Try->import::into($target);
}

1;

__DATA__
# this is just for use by data-section-simple.pl using Data::Section::Simple
