package Local::SendGrid;

use 5.34.0;

use Moo;
use IO::All;
use Data::Printer;
use Email::SendGrid::V3;
use Types::Standard qw(HashRef); # Str ArrayRef  Object

has msg => ( is => 'ro', isa => HashRef, required => 1 );

# ZBOX Ubuntu 22.04 key:
my $api_key = io('/home/raj/.local/sendgrid_api_key')->slurp; # say $api_key;

sub send {
	my $msg = shift->msg;
	
	my $sg = Email::SendGrid::V3->new(api_key => $api_key)
		->from($msg->{from})
		->subject($msg->{subject})
		->add_content('text/plain', $msg->{text})
		->add_envelope( to => [ $msg->{to} ] ); # p $sg;
	
	my $result = $sg->send; # p $result;
	return $result->{success}
		? "Email success" : "Email failure: " . $result->{reason};
}