package Local::Paginator;

# adapted from Template::Plugin::Bootstrap::Pagination
use strict;
use warnings;

use Template;
use Data::Page;
use Data::Printer alias => 'ddp';

use base qw(Exporter);
our @EXPORT_OK = qw(paginate);

my $pagination_template_string = <<"EOTEMPLATE";
[%- USE Bootstrap.Pagination -%]
[%- Bootstrap.Pagination.pagination(pager = pager, uri = uri, siblings = sibs,
    version = 3) -%]
EOTEMPLATE

my $pager_template_string = <<"EOTEMPLATE";
[%- USE Bootstrap.Pagination -%]
[%- Bootstrap.Pagination.pager(pager = pager, uri = uri, version = 3) -%]
EOTEMPLATE

sub paginate {
    my $args = shift; # p $args; # uri, total_entries, entries_per_page, current_page, sibs

    my $pager = Data::Page->new();
    $pager->$_($args->{$_}) for qw(total_entries entries_per_page current_page);

    my $uri = $args->{uri} . '__PAGE__'; # placeholder replaced inline
    my $sibs = $args->{sibs} || 5;
    my $template = Template->new(STRICT => 1);

    my %html = ();
    {
        my $output;
        $template->process(\$pagination_template_string, {
            pager => $pager,
            sibs  => $sibs,
            uri   => $uri,
        }, \$output) or die $template->error();
        $html{pagination} = $output;
    }
    {
        my $output;
        $template->process(\$pager_template_string, {
            pager => $pager,
            uri   => $uri,
        }, \$output) or die $template->error();
        $html{pager} = $output;
    } # ddp %html;
    # add formatted html to args:
    $args->{html} = \%html;
    return $args;
}

1;
