package Local::Base;

# load common modules
# maybe issues with Moo::Role, see https://metacpan.org/pod/Import::Base#KNOWN-ISSUES

use parent 'Import::Base';

# Modules that are always imported
our @IMPORT_MODULES = (
    'strict',
    'autodie',
    'warnings',
  # Disable uninitialized warnings
    # '-warnings' => [ 'uninitialized' ],
  # For 'say', 'switch', 'given', etc, if not specifying recent perl version:
    feature => [ ':5.20' ],
    FindBin => [ '$Bin' ],
    'Path::Tiny', # slurp/slurp_raw/slurp_utf8
    'match::simple', # eg $foo |M| $bar
    'Data::Printer',
    'Carp::Always::Color',
    'Syntax::Keyword::Try',
);

# Optional bundles
our %IMPORT_BUNDLES = (
    OO => [
        '<Moo', # Put this first so we can override what it enables later
        'Types::Standard' => [ qw /Num Str ArrayRef HashRef Object InstanceOf/ ], # or ':all'
    ],
    DB => [
        'Local::DB',
        'Local::SQL::Abstract::Plugin::InsertMulti',
    ],
    Utils => [
        'List::Util' => [ qw/min max first any all/ ], # don't need sum():
        'Local::Utils', # has math_sum()
    ],
);

1;
